<?php
  BIndex::Add('ViewCounts', 'file');
  BaseFileIndex::$noBuffering['view-counts'] = true;  // concurrent post views are not uncommon.

  BEvent::HookInstanceOf('ViewcountsFileIndex', 'Rename', 'post moved');

  BEvent::HookInstanceOf('ViewcountsFileIndex', 'Add', 'post viewed');
  BEvent::HookInstanceOf('ViewcountsFileIndex', 'PostsViewed', 'posts viewed');

  BEvent::HookInstanceOf('ViewcountsFileIndex', 'PostHitsToFooter', 'post footer');
  BEvent::HookInstanceOf('ViewcountsFileIndex', 'TotalHitsToFooter', 'posts footer');

  BConfig::$strings += array('view counts' => '$ hit, s, , s, s',
                             'view counts: total' => '%s site-wise');

/* one-shot */
  $this->name = 'view counts';
  $this->Caption('Число просмотров', 'ru');
  $this->info['user files'] = array('ViewcountsFileIndex', 'UserFiles');
/* install ViewcountsFileIndex */
class ViewcountsFileIndex extends BaseIntHashFileIndex {
  static $countRobots = false;

  const TotalHits = '*';
  public $indexName = 'view-counts';

  function Add($post) {
    parent::Add($post);
    parent::Add(self::TotalHits);
  }

    function TotalHits() {
      $hits = $this->Select(self::TotalHits);
      return $hits ? $hits : 0;
    }

  function PostsViewed($posts) {
    if (!IsRobotAgent() or self::$countRobots) {
      parent::Add(self::TotalHits);
    }
  }

  function PostHitsToFooter(&$footer, $post) {
    $hits = $this->Select($post);
    $footer[] = '<strong>'.TranslateNumber('view counts', $hits).'</strong>';
  }

  function TotalHitsToFooter(&$footer, $posts) {
    $hits = $this->TotalHits();
    $hits = '<strong>'. TranslateNumber('view counts', $hits) .'</strong>';
    $footer[] = Translate('view counts: total', $hits);
  }

  static function UserFiles() { return self::FileOf(SingleInstanceOf(__CLASS__)->indexName); }
}
